import flet as ft


def main(page: ft.Page):
    page.title = "1.4 Горячие клавиши – простой пример"

    info = ft.Text("Нажмите любую клавишу в сочетании с CTRL, ALT, SHIFT и META...")
    result = ft.Text(
        "Клавиша: -, Shift: False, Control: False, Alt: False, Meta: False"
    )

    def on_keyboard(e: ft.KeyboardEvent):
        result.value = (
            f"Клавиша: {e.key}, "
            f"Shift: {e.shift}, "
            f"Control: {e.ctrl}, "
            f"Alt: {e.alt}, "
            f"Meta: {e.meta}"
        )
        page.update()

    page.on_keyboard_event = on_keyboard
    page.add(info, result)


if __name__ == "__main__":
    ft.app(target=main)
